#include <ESP8266WiFi.h>

// WiFi & Server related
WiFiClient client;
byte connState;
const char *ssid = "testingiot"; // the ssid of the AP        
const char *password = "testingiot"; // the password of the AP  
char ipServ[20] = "192.168.0.2"; // setup default server address
int portServ = 12345; // setup default port
String idClient;

#define PIN_LED D1
#define PIN_BUTTON D2

volatile byte stateButton;
volatile long time1;
volatile long time2;
volatile boolean mustSendReq = false;

#define SERIAL_BAUD 115200

#define uS_TO_S_FACTOR 1000000ULL  /* Conversion factor for micro seconds to seconds */
#define TIME_TO_SLEEP  5        /* Time ESP32 will go to sleep (in seconds) */

void ICACHE_RAM_ATTR getState()  {
  stateButton = digitalRead(PIN_BUTTON);  
  if(stateButton == 1) {
    digitalWrite(PIN_LED,HIGH);  
    time1 = millis();  
  }
  else {
    digitalWrite(PIN_LED,LOW);
    time2 = millis();  
    mustSendReq = true;
  }  
}

void setupWifi() {
  const char *ssid = "testingiot"; // the ssid of the AP        
  const char *password = "testingiot"; // the password of the AP  
  int ret = 0;
  // comment 2 following lines if not needed
  WiFi.setAutoConnect(false);  // see comments   
  //WiFi.setSleepMode(WIFI_NONE_SLEEP); // always active => big consumption

  ret = WiFi.mode (WIFI_STA); // setup as a wifi client
  Serial.println("setting Wifi mode: "+String(ret));

  ret = WiFi.begin(ssid,password); // try to connect
  Serial.println("begin connection to AP: "+String(ret));
  while (WiFi.status() != WL_CONNECTED) { // check connection
    delay(500); 
    Serial.print(".");
  } 
  // debug messages
  Serial.print("Connected, IP address: ");
  Serial.println(WiFi.localIP());  
}

bool setupServerConnection() {
  if (client.connect(ipServ, portServ)) {
    connState = 1;
    Serial.println("connected to server");
    // disable buffering small mesg
    client.setNoDelay(true);
    // receive my id from the server
    idClient = readLineServer();
    Serial.println("my id is "+idClient);    
    return true;
  }
  else {
    connState = 0;
    Serial.println("connection failed");
    return false;
  }
}

String readLineServer() {
  char buffer[1024];
  memset(buffer,0,1024);    // reset buffer
  int index = 0; 
  char c;  
  while(true) {
    while (!client.available()) {} // wait for smthg to read
    while ((index < 1023) && (client.available())) {
      c = client.read();
      if (c == '\n') return String(buffer); // end-of-line reached => return
      buffer[index++] = c; // store the char
    }
    if (index == 1023) return String(buffer); 
  }  
}

void sendButtonTimes() {
  
  String req = "PRESS "+idClient+" "+time1+" "+time2;
  Serial.println("sending request: "+req);
  client.println(req);  
}

void setup() {
  Serial.begin(SERIAL_BAUD);
  pinMode(PIN_LED,OUTPUT);
  pinMode(PIN_BUTTON,INPUT);
  setupWifi();
  delay(100);
  attachInterrupt(digitalPinToInterrupt(PIN_BUTTON),getState,CHANGE);
}

void loop() {
  if (connState == 0) {
    if (! setupServerConnection()) { delay(1000); }
  }
  else {
    if (mustSendReq) {
      sendButtonTimes();
      String answer = readLineServer();
      if (answer.equals("OK")) {
        answer = readLineServer();
        Serial.println("servers answers: "+answer);
      }
      else {
        Serial.println("server reports an error: "+answer);
      }
      mustSendReq = false;
    }
  }
}


