#include <ESP8266WiFi.h>

// WiFi & Server related
WiFiClient client;
byte connState;
const char *ssid = "testingiot"; // the ssid of the AP        
const char *password = "testingiot"; // the password of the AP  
char ipServ[20] = "192.168.0.2"; // setup default server address
int portServ = 12345; // setup default port
String idClient;

#define PIN_PIEZO A0

int piezoLevel;
volatile boolean mustSendReq = false;

#define SERIAL_BAUD 115200

#define uS_TO_S_FACTOR 1000000ULL  /* Conversion factor for micro seconds to seconds */
#define TIME_TO_SLEEP  5        /* Time ESP32 will go to sleep (in seconds) */

void setupWifi() {
  const char *ssid = "testingiot"; // the ssid of the AP        
  const char *password = "testingiot"; // the password of the AP  
  int ret = 0;
  // comment 2 following lines if not needed
  WiFi.setAutoConnect(false);  // see comments   
  //WiFi.setSleepMode(WIFI_NONE_SLEEP); // always active => big consumption

  ret = WiFi.mode (WIFI_STA); // setup as a wifi client
  Serial.println("setting Wifi mode: "+String(ret));

  ret = WiFi.begin(ssid,password); // try to connect
  Serial.println("begin connection to AP: "+String(ret));
  while (WiFi.status() != WL_CONNECTED) { // check connection
    delay(500); 
    Serial.print(".");
  } 
  // debug messages
  Serial.print("Connected, IP address: ");
  Serial.println(WiFi.localIP());  
}

bool setupServerConnection() {
  if (client.connect(ipServ, portServ)) {
    connState = 1;
    Serial.println("connected to server");
    // disable buffering small mesg
    client.setNoDelay(true);
    // receive my id from the server
    idClient = readLineServer();
    Serial.println("my id is "+idClient);    
    return true;
  }
  else {
    connState = 0;
    Serial.println("connection failed");
    return false;
  }
}

String readLineServer() {
  char buffer[1024];
  memset(buffer,0,1024);    // reset buffer
  int index = 0; 
  char c;  
  while(true) {
    while (!client.available()) {} // wait for smthg to read
    while ((index < 1023) && (client.available())) {
      c = client.read();
      if (c == '\n') return String(buffer); // end-of-line reached => return
      buffer[index++] = c; // store the char
    }
    if (index == 1023) return String(buffer); 
  }  
}

void sendPiezoLevel() {
  
  String req = "PIEZO "+idClient+" "+piezoLevel;
  Serial.println("sending request: "+req);
  client.println(req);  
}

void setup() {
  Serial.begin(SERIAL_BAUD);
  setupWifi();
  delay(100);  
}

void loop() {
  if (connState == 0) {
    if (! setupServerConnection()) { delay(1000); }
  }
  else {
    piezoLevel = analogRead(PIN_PIEZO);
    if (piezoLevel >= 500) {
      sendPiezoLevel();
      String answer = readLineServer();      
      if (answer.equals("OK")) {
        answer = readLineServer();
        Serial.println("servers answers: "+answer);
      }
      else {
        Serial.println("server reports an error: "+answer);
      }
      delay(500);
    }
  }
  delay(3);
}


